/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.InfusionAltarTileEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InfusionAltarBlock
extends BaseTileEntityBlock {
    public static final VoxelShape ALTAR_SHAPE = new VoxelShapeBuilder().cuboid(0.0, 0.0, 0.0, 16.0, 8.0, 16.0).cuboid(3.0, 13.0, 3.0, 13.0, 14.0, 13.0).cuboid(6.0, 10.0, 6.0, 10.0, 11.0, 10.0).cuboid(5.0, 11.0, 5.0, 11.0, 13.0, 11.0).cuboid(2.0, 13.5, 4.0, 3.0, 14.5, 12.0).cuboid(13.0, 13.5, 4.0, 14.0, 14.5, 12.0).cuboid(4.0, 13.5, 2.0, 12.0, 14.5, 3.0).cuboid(4.0, 13.5, 13.0, 12.0, 14.5, 14.0).cuboid(0.5, 8.0, 4.0, 4.0, 10.0, 12.0).cuboid(2.0, 8.0, 0.5, 14.0, 10.0, 4.0).cuboid(12.0, 8.0, 4.0, 15.5, 10.0, 12.0).cuboid(2.0, 8.0, 12.0, 14.0, 10.0, 15.5).cuboid(14.0, 8.0, 2.0, 15.5, 10.0, 4.0).cuboid(14.0, 8.0, 12.0, 15.5, 10.0, 14.0).cuboid(0.5, 8.0, 12.0, 2.0, 10.0, 14.0).cuboid(0.5, 8.0, 2.0, 2.0, 10.0, 4.0).cuboid(0.25, 8.0, 14.0, 2.0, 9.0, 15.75).cuboid(14.0, 8.0, 14.0, 15.75, 9.0, 15.75).cuboid(14.0, 8.0, 0.25, 15.75, 9.0, 2.0).cuboid(0.25, 8.0, 0.25, 2.0, 9.0, 2.0).cuboid(5.0, 8.0, 5.0, 11.0, 10.0, 11.0).build();

    public InfusionAltarBlock() {
        super(Material.f_76278_, SoundType.f_56742_, 10.0f, 12.0f, true);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InfusionAltarTileEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof InfusionAltarTileEntity) {
            InfusionAltarTileEntity altar = (InfusionAltarTileEntity)tile;
            BaseItemStackHandler inventory = altar.getInventory();
            ItemStack input = inventory.getStackInSlot(0);
            ItemStack output = inventory.getStackInSlot(1);
            if (!output.m_41619_()) {
                ItemEntity item = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), output);
                item.m_32061_();
                world.m_7967_((Entity)item);
                inventory.setStackInSlot(1, ItemStack.f_41583_);
            } else {
                ItemStack held = player.m_21120_(hand);
                if (input.m_41619_() && !held.m_41619_()) {
                    inventory.setStackInSlot(0, StackHelper.withSize((ItemStack)held, (int)1, (boolean)false));
                    player.m_21008_(hand, StackHelper.shrink((ItemStack)held, (int)1, (boolean)false));
                    world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (!input.m_41619_()) {
                    ItemEntity item = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), input);
                    item.m_32061_();
                    world.m_7967_((Entity)item);
                    inventory.setStackInSlot(0, ItemStack.f_41583_);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.m_60734_() != newState.m_60734_() && (tile = world.m_7702_(pos)) instanceof InfusionAltarTileEntity) {
            InfusionAltarTileEntity altar = (InfusionAltarTileEntity)tile;
            Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)altar.getInventory().getStacks());
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos post, CollisionContext context) {
        return ALTAR_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)ModTooltips.ACTIVATE_WITH_REDSTONE.build());
    }

    protected <T extends BlockEntity> BlockEntityTicker<T> getServerTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return InfusionAltarBlock.createTicker(type, (BlockEntityType)((BlockEntityType)ModTileEntities.INFUSION_ALTAR.get()), InfusionAltarTileEntity::tick);
    }
}

